document.addEventListener('DOMContentLoaded', function() {
    const calendarBody = document.getElementById('calendar-body');
    const currentMonthElement = document.getElementById('current-month');
    const prevMonthButton = document.getElementById('prev-month');
    const nextMonthButton = document.getElementById('next-month');
    const todayButton = document.getElementById('today'); // Add the "Today" button

    let currentDate = new Date();
    let currentYear = currentDate.getFullYear();
    let currentMonth = currentDate.getMonth();

    // Bangla month and day names
    const banglaMonthNames = [
        "জানুয়ারি", "ফেব্রুয়ারি", "মার্চ", "এপ্রিল", "মে", "জুন",
        "জুলাই", "আগস্ট", "সেপ্টেম্বর", "অক্টোবর", "নভেম্বর", "ডিসেম্বর"
    ];
    const banglaDayNames = [
        "রবি", "সোম", "মঙ্গল", "বুধ", "বৃহঃ", "শুক্র", "শনি"
    ];

    function generateCalendar(year, month) {
        calendarBody.innerHTML = '';

        // Get the first day of the month and the number of days in the month
        const firstDay = new Date(year, month, 1);
        const lastDay = new Date(year, month + 1, 0);

        currentMonthElement.textContent = `${banglaMonthNames[month]} ${year}`;

        // Fill the calendar with the days
        let day = 1;
        for (let i = 0; i < 6; i++) {
            const row = document.createElement('tr');
            for (let j = 0; j < 7; j++) {
                const cell = document.createElement('td');
                if (i === 0 && j < firstDay.getDay()) {
                    cell.className = 'empty';
                } else if (day <= lastDay.getDate()) {
                    cell.textContent = day;
                    if (year === currentDate.getFullYear() && month === currentDate.getMonth() && day === currentDate.getDate()) {
                        cell.className = 'today';
                    }
                    day++;
                } else {
                    cell.className = 'empty';
                }
                row.appendChild(cell);
            }
            calendarBody.appendChild(row);
        }
    }

    generateCalendar(currentYear, currentMonth);

    prevMonthButton.addEventListener('click', function() {
        if (currentMonth === 0) {
            currentYear--;
            currentMonth = 11;
        } else {
            currentMonth--;
        }
        generateCalendar(currentYear, currentMonth);
    });

    nextMonthButton.addEventListener('click', function() {
        if (currentMonth === 11) {
            currentYear++;
            currentMonth = 0;
        } else {
            currentMonth++;
        }
        generateCalendar(currentYear, currentMonth);
    });

    todayButton.addEventListener('click', function() {
        currentDate = new Date();
        currentYear = currentDate.getFullYear();
        currentMonth = currentDate.getMonth();
        generateCalendar(currentYear, currentMonth);
    });
});